# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new publishing page and add a web part
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# File name for the page
$pageFileName = "PowerShellPageWithWebPart.aspx"

# Title of the page
$title = "PowerShell Page with Web Part"

# Name of the page layout
$layoutName = "Blank Web Part Page"

# Content to add to the content editor web part
$webPartContent = "PowerShell Page Content"

# Title for the web part
$webPartTitle = "PowerShell Web Part"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl
	
# Get the Publishing Site from the SharePoint Site
$pubWeb = [Microsoft.SharePoint.Publishing.PublishingWeb]::GetPublishingWeb($web)

# Get the specified Page Layout from the available layouts
$layout = $pubWeb.GetAvailablePageLayouts() | Where-Object { $_.Title -eq $layoutName }

# Create the new Page
$page = $pubWeb.AddPublishingPage($pageFileName, $layout)
$page.Update()

# Set the Title of the Page
$page.ListItem["Title"] = $title
$page.ListItem.Update()

# Get the Web Part Manager for the Page
$wpm = $web.GetLimitedWebPartManager($page.Url, [System.Web.UI.WebControls.WebParts.PersonalizationScope]::Shared)

# Create a new Content Editor Web Part
$cewp = New-Object Microsoft.SharePoint.WebPartPages.ContentEditorWebPart
$cewp.Title = $webPartTitle
$cewp.ChromeType = [System.Web.UI.WebControls.WebParts.PartChromeType]::TitleOnly
$xml = New-Object System.Xml.XmlDocument
$xml.LoadXml("<Content>" + $webPartContent + "</Content>")
$cewp.Content = $xml.FirstChild

# Add the Web Part to the Page
$wpm.AddWebPart($cewp, "Header", 0)

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 